<?php
require_once __DIR__.'/../db.php';
require_once __DIR__.'/../helpers.php';
require_once __DIR__.'/partials/header.php';
require_once __DIR__.'/partials/navbar.php';
$sent = false;
if ($_SERVER['REQUEST_METHOD']==='POST') {
  check_csrf();
  $name = trim($_POST['name']??'');
  $email = trim($_POST['email']??'');
  $msg = trim($_POST['message']??'');
  $stmt = $mysqli->prepare("INSERT INTO enquiries(name,email,message,created_at) VALUES (?,?,?,NOW())");
  $stmt->bind_param('sss',$name,$email,$msg);
  $sent = $stmt->execute();
}
$res = $mysqli->query("SELECT title, content FROM pages WHERE slug='contact'");
$page = $res ? $res->fetch_assoc() : null;
?>
<div class="container my-5" style="max-width:720px;">
  <h2>Contact Us</h2>
  <?php if($sent): ?><div class="alert alert-success">Thanks! We'll get back to you soon.</div><?php endif; ?>
  <p class="text-muted"><?php echo $page? $page['content'] : 'Fill the form below to reach us.'; ?></p>
  <form method="post" class="card card-body">
    <?php csrf_field(); ?>
    <div class="row">
      <div class="col-md-6">
        <label class="form-label">Name</label>
        <input class="form-control" name="name" required>
      </div>
      <div class="col-md-6">
        <label class="form-label">Email</label>
        <input class="form-control" type="email" name="email" required>
      </div>
    </div>
    <div class="mt-3">
      <label class="form-label">Message</label>
      <textarea class="form-control" rows="5" name="message" required></textarea>
    </div>
    <button class="btn btn-primary mt-3">Send</button>
  </form>
</div>
<?php require_once __DIR__.'/partials/footer.php'; ?>
