<?php
// Run this once after creating an empty database named in config.php (default: bus_pass_db).
require_once __DIR__.'/../config.php';
$mysqli = new mysqli(DB_HOST, DB_USER, DB_PASS);
if ($mysqli->connect_errno) { die('MySQL connection failed: ' . $mysqli->connect_error); }
$mysqli->query("CREATE DATABASE IF NOT EXISTS `".DB_NAME."` CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
$mysqli->select_db(DB_NAME);

// Create tables
$schema = <<<SQL
CREATE TABLE IF NOT EXISTS users (
  id INT AUTO_INCREMENT PRIMARY KEY,
  name VARCHAR(100) NOT NULL,
  email VARCHAR(150) NOT NULL UNIQUE,
  password_hash VARCHAR(255) NOT NULL,
  role ENUM('admin','user') NOT NULL DEFAULT 'user',
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);
CREATE TABLE IF NOT EXISTS categories (
  id INT AUTO_INCREMENT PRIMARY KEY,
  name VARCHAR(100) NOT NULL,
  description TEXT,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);
CREATE TABLE IF NOT EXISTS passes (
  id INT AUTO_INCREMENT PRIMARY KEY,
  pass_number VARCHAR(50) NOT NULL UNIQUE,
  user_name VARCHAR(120) NOT NULL,
  user_email VARCHAR(150) NOT NULL,
  category_id INT NOT NULL,
  valid_from DATE NOT NULL,
  valid_to DATE NOT NULL,
  price DECIMAL(10,2) NOT NULL DEFAULT 0,
  status ENUM('active','expired','blocked') NOT NULL DEFAULT 'active',
  photo_url VARCHAR(255) NULL,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  FOREIGN KEY(category_id) REFERENCES categories(id) ON DELETE CASCADE
);
CREATE TABLE IF NOT EXISTS pages (
  slug VARCHAR(50) PRIMARY KEY,
  title VARCHAR(150) NOT NULL,
  content MEDIUMTEXT,
  updated_at TIMESTAMP NULL DEFAULT NULL
);
CREATE TABLE IF NOT EXISTS enquiries (
  id INT AUTO_INCREMENT PRIMARY KEY,
  name VARCHAR(120) NOT NULL,
  email VARCHAR(150) NOT NULL,
  message TEXT NOT NULL,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);
SQL;
$mysqli->multi_query($schema);
while($mysqli->more_results() && $mysqli->next_result()) { /* flush results */ }

// Seed pages
$mysqli->query("INSERT IGNORE INTO pages(slug,title,content,updated_at) VALUES
('about','About Us','<p>We provide safe and reliable city transportation. Manage passes online with ease.</p>',NOW()),
('contact','Contact Us','<p>Email: support@example.com<br>Phone: +91 98765 43210</p>',NOW())");

// Seed categories
$cats = [
  ['Student Monthly','Discounted monthly pass for students'],
  ['General Monthly','Standard monthly city pass'],
  ['Senior Citizen','Concessional pass for seniors'],
  ['Weekly Tourist','Unlimited travel for a week']
];
$stmt = $mysqli->prepare("INSERT INTO categories(name,description) VALUES (?,?)");
foreach($cats as $c){ $stmt->bind_param('ss',$c[0],$c[1]); $stmt->execute(); }

// Create admin
$adminEmail = $_GET['email'] ?? getenv('ADMIN_EMAIL') ?? DEFAULT_ADMIN_EMAIL;
$adminPass  = $_GET['password'] ?? getenv('ADMIN_PASSWORD') ?? DEFAULT_ADMIN_PASSWORD;
$hash = password_hash($adminPass, PASSWORD_BCRYPT);
$stmt = $mysqli->prepare("INSERT IGNORE INTO users(name,email,password_hash,role) VALUES('Administrator',?,?, 'admin')");
$stmt->bind_param('ss',$adminEmail,$hash);
$stmt->execute();

// Sample passes
function passnum(){ return 'BP-'.date('Y').'-'.str_pad((string)rand(1,9999),4,'0',STR_PAD_LEFT); }
$emails = ['alice@example.com','bob@example.com','carol@example.com','dan@example.com','eric@example.com'];
$names = ['Alice','Bob','Carol','Dan','Eric'];
for($i=0;$i<8;$i++){
  $user = $names[array_rand($names)];
  $email = $emails[array_rand($emails)];
  $catId = $mysqli->query("SELECT id FROM categories ORDER BY RAND() LIMIT 1")->fetch_assoc()['id'];
  $from = date('Y-m-d', strtotime('-'.rand(0,10).' days'));
  $to = date('Y-m-d', strtotime('+'.rand(10,40).' days'));
  $price = rand(200,1500);
  $status = 'active';
  $photo = '/public/assets/img/bus-hero.svg';
  $stmt = $mysqli->prepare("INSERT IGNORE INTO passes(pass_number,user_name,user_email,category_id,valid_from,valid_to,price,status,photo_url) VALUES (?,?,?,?,?,?,?,?,?)");
  $pn = passnum();
  $stmt->bind_param('sssssssss',$pn,$user,$email,$catId,$from,$to,$price,$status,$photo);
  $stmt->execute();
}

echo "Seed complete. Admin: {$adminEmail} / {$adminPass}";
?>