<?php
require_once __DIR__.'/../db.php';
require_once __DIR__.'/partials/header.php';
require_once __DIR__.'/partials/navbar.php';
?>
<div class="hero text-white">
  <div class="overlay text-center">
    <h1 class="display-5 fw-bold">City Bus Passes, Managed Effortlessly</h1>
    <p class="lead">Buy, view, and print bus passes online. Admins can manage categories, passes, pages, enquiries & reports.</p>
    <a href="/public/view-pass.php" class="btn btn-primary btn-lg">View Your Pass</a>
  </div>
</div>

<div class="container my-5">
  <h2 class="mb-4">Pass Categories</h2>
  <div class="row g-4">
<?php
$res = $mysqli->query("SELECT id, name, description FROM categories ORDER BY id DESC LIMIT 8");
if ($res && $res->num_rows) {
    while($row = $res->fetch_assoc()){
        echo '<div class="col-md-3"><div class="card card-category h-100">';
        echo '<div class="card-body">';
        echo '<h5 class="card-title">'.e($row['name']).'</h5>';
        echo '<p class="card-text">'.e(mb_strimwidth($row['description'],0,120,'...')).'</p>';
        echo '</div></div></div>';
    }
} else {
    echo '<p class="text-muted">No categories yet. Admin can add some from the dashboard.</p>';
}
?>
  </div>

  <hr class="my-5">
  <h2 class="mb-3">Featured Passes</h2>
  <div class="row g-4">
<?php
$res = $mysqli->query("SELECT p.pass_number, p.user_name, c.name AS category, DATE_FORMAT(p.valid_from, '%d %b %Y') vf, DATE_FORMAT(p.valid_to, '%d %b %Y') vt FROM passes p JOIN categories c ON c.id = p.category_id ORDER BY p.id DESC LIMIT 6");
if ($res && $res->num_rows) {
    while($row = $res->fetch_assoc()){
        echo '<div class="col-md-4"><div class="card h-100">';
        echo '<div class="card-body">';
        echo '<h5 class="card-title">Pass #'.e($row['pass_number']).'</h5>';
        echo '<p class="card-text"><strong>Name:</strong> '.e($row['user_name']).'<br>';
        echo '<strong>Category:</strong> '.e($row['category']).'<br>';
        echo '<strong>Validity:</strong> '.e($row['vf']).' - '.e($row['vt']).'</p>';
        echo '</div></div></div>';
    }
} else {
    echo '<p class="text-muted">No passes yet.</p>';
}
?>
  </div>
</div>
<?php require_once __DIR__.'/partials/footer.php'; ?>
