<?php
require_once __DIR__.'/../db.php';
require_once __DIR__.'/../auth.php';
require_once __DIR__.'/../helpers.php';
require_admin();
$user_id = $_SESSION['user']['id'];
$ok = null; $err=null;
if ($_SERVER['REQUEST_METHOD']==='POST') {
  check_csrf();
  if (isset($_POST['name'])) {
    $stmt = $mysqli->prepare("UPDATE users SET name=? WHERE id=?");
    $stmt->bind_param('si', $_POST['name'], $user_id); $ok = $stmt->execute();
  } elseif(isset($_POST['old_password'])) {
    $stmt = $mysqli->prepare("SELECT password_hash FROM users WHERE id=?");
    $stmt->bind_param('i',$user_id); $stmt->execute(); $ph = $stmt->get_result()->fetch_assoc()['password_hash'];
    if (password_verify($_POST['old_password'], $ph)) {
      $new = password_hash($_POST['new_password'], PASSWORD_BCRYPT);
      $stmt = $mysqli->prepare("UPDATE users SET password_hash=? WHERE id=?");
      $stmt->bind_param('si',$new,$user_id); $ok = $stmt->execute();
    } else { $err = 'Old password incorrect.'; }
  }
}
$stmt = $mysqli->prepare("SELECT name,email FROM users WHERE id=?"); $stmt->bind_param('i',$user_id); $stmt->execute(); $me = $stmt->get_result()->fetch_assoc();
?>
<!doctype html><html><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
<title>Profile</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head><body class="bg-light">
<div class="container my-4" style="max-width:720px;">
  <h3>My Profile</h3>
  <?php if($ok): ?><div class="alert alert-success">Updated.</div><?php endif; ?>
  <?php if($err): ?><div class="alert alert-danger"><?php echo htmlspecialchars($err); ?></div><?php endif; ?>
  <div class="card card-body mb-3">
    <form method="post">
      <?php csrf_field(); ?>
      <label class="form-label">Name</label>
      <input class="form-control" name="name" value="<?php echo htmlspecialchars($me['name']); ?>">
      <label class="form-label mt-3">Email</label>
      <input class="form-control" value="<?php echo htmlspecialchars($me['email']); ?>" disabled>
      <button class="btn btn-primary mt-3">Save</button>
    </form>
  </div>
  <div class="card card-body">
    <form method="post">
      <?php csrf_field(); ?>
      <label class="form-label">Old Password</label>
      <input class="form-control" type="password" name="old_password" required>
      <label class="form-label mt-3">New Password</label>
      <input class="form-control" type="password" name="new_password" required>
      <button class="btn btn-warning mt-3">Change Password</button>
    </form>
  </div>
</div>
</body></html>
