<?php
require_once __DIR__.'/../db.php';
require_once __DIR__.'/../auth.php';
require_once __DIR__.'/../helpers.php';
require_admin();
check_csrf();
function random_pass_number($mysqli){
  do {
    $num = 'BP-'.date('Y').'-'.str_pad((string)rand(1,9999),4,'0',STR_PAD_LEFT);
    $stmt = $mysqli->prepare("SELECT 1 FROM passes WHERE pass_number=?");
    $stmt->bind_param('s',$num); $stmt->execute();
    $exists = $stmt->get_result()->fetch_row();
  } while($exists);
  return $num;
}
if ($_SERVER['REQUEST_METHOD']==='POST') {
  $action = $_POST['action'] ?? '';
  if ($action==='create') {
    $num = random_pass_number($mysqli);
    $stmt = $mysqli->prepare("INSERT INTO passes(pass_number,user_name,user_email,category_id,valid_from,valid_to,price,status,photo_url,created_at) VALUES (?,?,?,?,?,?,?,?,?,NOW())");
    $stmt->bind_param('sssssssss',$num,$_POST['user_name'],$_POST['user_email'],$_POST['category_id'],$_POST['valid_from'],$_POST['valid_to'],$_POST['price'],$_POST['status'],$_POST['photo_url']);
    $stmt->execute();
  } elseif ($action==='update') {
    $stmt = $mysqli->prepare("UPDATE passes SET user_name=?,user_email=?,category_id=?,valid_from=?,valid_to=?,price=?,status=?,photo_url=? WHERE id=?");
    $stmt->bind_param('ssssssssi',$_POST['user_name'],$_POST['user_email'],$_POST['category_id'],$_POST['valid_from'],$_POST['valid_to'],$_POST['price'],$_POST['status'],$_POST['photo_url'],$_POST['id']);
    $stmt->execute();
  } elseif ($action==='delete') {
    $stmt = $mysqli->prepare("DELETE FROM passes WHERE id=?");
    $stmt->bind_param('i',$_POST['id']); $stmt->execute();
  }
  header('Location: /admin/passes.php'); exit;
}
$cats = $mysqli->query("SELECT id,name FROM categories ORDER BY name ASC")->fetch_all(MYSQLI_ASSOC);
$rows = $mysqli->query("SELECT p.*, c.name AS category FROM passes p JOIN categories c ON c.id=p.category_id ORDER BY p.id DESC LIMIT 50");
?>
<!doctype html><html><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
<title>Passes</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head><body class="bg-light">
<div class="container my-4">
  <div class="d-flex justify-content-between align-items-center">
    <h3>Passes</h3>
    <div>
      <a class="btn btn-secondary" href="/admin/dashboard.php">Back</a>
    </div>
  </div>
  <form method="post" class="card card-body my-3">
    <?php csrf_field(); ?>
    <input type="hidden" name="action" value="create">
    <div class="row g-3">
      <div class="col-md-3"><input class="form-control" name="user_name" placeholder="User name" required></div>
      <div class="col-md-3"><input class="form-control" name="user_email" type="email" placeholder="User email" required></div>
      <div class="col-md-2">
        <select class="form-select" name="category_id" required>
          <option value="">Category</option>
          <?php foreach($cats as $c): ?><option value="<?php echo $c['id']; ?>"><?php echo e($c['name']); ?></option><?php endforeach; ?>
        </select>
      </div>
      <div class="col-md-2"><input class="form-control" type="date" name="valid_from" required></div>
      <div class="col-md-2"><input class="form-control" type="date" name="valid_to" required></div>
      <div class="col-md-2"><input class="form-control" name="price" placeholder="Price" required></div>
      <div class="col-md-2">
        <select class="form-select" name="status">
          <option>active</option><option>expired</option><option>blocked</option>
        </select>
      </div>
      <div class="col-md-4"><input class="form-control" name="photo_url" placeholder="Photo URL (optional)"></div>
      <div class="col-md-2"><button class="btn btn-primary w-100">Create</button></div>
    </div>
  </form>
  <div class="table-responsive">
    <table class="table table-striped align-middle">
      <thead><tr><th>ID</th><th>Pass #</th><th>Name</th><th>Email</th><th>Category</th><th>Valid</th><th>Status</th><th>Actions</th></tr></thead>
      <tbody>
      <?php while($r=$rows->fetch_assoc()): ?>
        <tr>
          <td><?php echo $r['id']; ?></td>
          <td><?php echo e($r['pass_number']); ?></td>
          <td><?php echo e($r['user_name']); ?></td>
          <td><?php echo e($r['user_email']); ?></td>
          <td><?php echo e($r['category']); ?></td>
          <td><?php echo e($r['valid_from'].' → '.$r['valid_to']); ?></td>
          <td><?php echo e($r['status']); ?></td>
          <td class="d-flex gap-1">
            <a class="btn btn-sm btn-outline-secondary" href="/admin/print-pass.php?id=<?php echo $r['id']; ?>" target="_blank">Print</a>
            <button class="btn btn-sm btn-outline-primary" onclick='prefill(<?php echo json_encode($r, JSON_HEX_APOS|JSON_HEX_TAG|JSON_HEX_AMP|JSON_HEX_QUOT); ?>)'>Edit</button>
            <form method="post" class="d-inline">
              <?php csrf_field(); ?>
              <input type="hidden" name="action" value="delete">
              <input type="hidden" name="id" value="<?php echo $r['id']; ?>">
              <button class="btn btn-sm btn-outline-danger" onclick="return confirm('Delete this pass?')">Delete</button>
            </form>
          </td>
        </tr>
      <?php endwhile; ?>
      </tbody>
    </table>
  </div>
  <div class="card card-body">
    <h5>Edit Pass</h5>
    <form method="post" id="editForm">
      <?php csrf_field(); ?>
      <input type="hidden" name="action" value="update">
      <input type="hidden" name="id" id="eid">
      <div class="row g-3">
        <div class="col-md-3"><input class="form-control" name="user_name" id="e_user_name" required></div>
        <div class="col-md-3"><input class="form-control" name="user_email" id="e_user_email" required></div>
        <div class="col-md-2">
          <select class="form-select" name="category_id" id="e_category_id" required>
            <?php foreach($cats as $c): ?><option value="<?php echo $c['id']; ?>"><?php echo e($c['name']); ?></option><?php endforeach; ?>
          </select>
        </div>
        <div class="col-md-2"><input class="form-control" type="date" name="valid_from" id="e_valid_from" required></div>
        <div class="col-md-2"><input class="form-control" type="date" name="valid_to" id="e_valid_to" required></div>
        <div class="col-md-2"><input class="form-control" name="price" id="e_price" required></div>
        <div class="col-md-2">
          <select class="form-select" name="status" id="e_status">
            <option>active</option><option>expired</option><option>blocked</option>
          </select>
        </div>
        <div class="col-md-4"><input class="form-control" name="photo_url" id="e_photo_url"></div>
        <div class="col-md-2"><button class="btn btn-primary w-100">Save</button></div>
      </div>
    </form>
  </div>
</div>
<script>
function prefill(r){
  document.getElementById('eid').value = r.id;
  document.getElementById('e_user_name').value = r.user_name;
  document.getElementById('e_user_email').value = r.user_email;
  document.getElementById('e_category_id').value = r.category_id;
  document.getElementById('e_valid_from').value = r.valid_from.substring(0,10);
  document.getElementById('e_valid_to').value = r.valid_to.substring(0,10);
  document.getElementById('e_price').value = r.price;
  document.getElementById('e_status').value = r.status;
  document.getElementById('e_photo_url').value = r.photo_url || '';
}
</script>
</body></html>
