<?php
require_once __DIR__.'/../db.php';
require_once __DIR__.'/../auth.php';
require_once __DIR__.'/../helpers.php';
require_admin();
check_csrf();
if ($_SERVER['REQUEST_METHOD']==='POST') {
  $action = $_POST['action'] ?? '';
  if ($action==='create') {
    $stmt = $mysqli->prepare("INSERT INTO categories(name,description,created_at) VALUES (?,?,NOW())");
    $stmt->bind_param('ss', $_POST['name'], $_POST['description']);
    $stmt->execute();
  } elseif ($action==='update') {
    $stmt = $mysqli->prepare("UPDATE categories SET name=?, description=? WHERE id=?");
    $stmt->bind_param('ssi', $_POST['name'], $_POST['description'], $_POST['id']);
    $stmt->execute();
  } elseif ($action==='delete') {
    $stmt = $mysqli->prepare("DELETE FROM categories WHERE id=?");
    $stmt->bind_param('i', $_POST['id']);
    $stmt->execute();
  }
  header('Location: /admin/categories.php'); exit;
}
$rows = $mysqli->query("SELECT * FROM categories ORDER BY id DESC");
?>
<!doctype html><html><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1">
<title>Categories</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head><body class="bg-light">
<div class="container my-4">
  <div class="d-flex justify-content-between align-items-center">
    <h3>Categories</h3>
    <a class="btn btn-secondary" href="/admin/dashboard.php">Back</a>
  </div>
  <form method="post" class="card card-body my-3">
    <?php csrf_field(); ?>
    <input type="hidden" name="action" value="create">
    <div class="row g-3">
      <div class="col-md-4"><input class="form-control" name="name" placeholder="Name" required></div>
      <div class="col-md-6"><input class="form-control" name="description" placeholder="Description"></div>
      <div class="col-md-2"><button class="btn btn-primary w-100">Add</button></div>
    </div>
  </form>
  <div class="table-responsive">
    <table class="table table-striped align-middle">
      <thead><tr><th>ID</th><th>Name</th><th>Description</th><th>Actions</th></tr></thead>
      <tbody>
      <?php while($r=$rows->fetch_assoc()): ?>
        <tr>
          <td><?php echo $r['id']; ?></td>
          <td><?php echo e($r['name']); ?></td>
          <td><?php echo e($r['description']); ?></td>
          <td>
            <form method="post" class="d-inline">
              <?php csrf_field(); ?>
              <input type="hidden" name="action" value="delete">
              <input type="hidden" name="id" value="<?php echo $r['id']; ?>">
              <button class="btn btn-sm btn-outline-danger" onclick="return confirm('Delete?')">Delete</button>
            </form>
            <button class="btn btn-sm btn-outline-primary" onclick="prefill(<?php echo $r['id']; ?>,'<?php echo e($r['name']); ?>','<?php echo e($r['description']); ?>')">Edit</button>
          </td>
        </tr>
      <?php endwhile; ?>
      </tbody>
    </table>
  </div>
  <div class="card card-body">
    <h5>Edit Category</h5>
    <form method="post" id="editForm">
      <?php csrf_field(); ?>
      <input type="hidden" name="action" value="update">
      <input type="hidden" name="id" id="eid">
      <div class="row g-3">
        <div class="col-md-4"><input class="form-control" name="name" id="ename" placeholder="Name" required></div>
        <div class="col-md-6"><input class="form-control" name="description" id="edesc" placeholder="Description"></div>
        <div class="col-md-2"><button class="btn btn-primary w-100">Save</button></div>
      </div>
    </form>
  </div>
</div>
<script>
function prefill(id,n,d){ document.getElementById('eid').value=id; document.getElementById('ename').value=n; document.getElementById('edesc').value=d; }
</script>
</body></html>
